<?php
namespace Core\Template;

/**
 * Description of Template
 *
 * @author Dmitriy
 */
class Template implements \Widgets\TemplateInterface{

    protected $name;

    protected $titles = [];

    protected $block = [];

    protected $content;

    protected $styles = [];

    protected $style;

    protected $scripts = [];

    protected $script;

    protected $pageHeader;

    /*
     * Разделитель сегментов для загаловка
     */

    public $title_separator = '|';

    /*
     * Направление загаловка
     */

    public $title_direction = 'LTR';

    function __construct($name = 'blank'){
	$this->name = $name;
    }

    public function addStyleLinks($links){
	if(is_array($links))
	    $this->styles	 = array_merge($this->styles, $links);
	else
	    $this->styles [] = $links;

	return $this;
    }

    public function addScriptLinks($links){
	if(is_array($links))
	    $this->scripts = array_merge($this->scripts, $links);
	else
	    $this->scripts []	 = $links;

	return $this;
    }

    public function addStyle($style){
	$this->style = $style;
	return $this;
    }

    public function addScript($script){
	$this->script .= $script;
	return $this;
    }

    function getStyles(){
	return $this->styles;
    }

    function getStyle(){
	return $this->style;
    }

    function getScripts(){
	return $this->scripts;
    }

    function getScript(){
	return $this->script;
    }

    function getName(){
	return $this->name;
    }

    function getTitle(){
	if($this->title_direction == 'RTL'){
	    krsort($this->titles);
	}
	return trim(trim(implode(" $this->title_separator ", $this->titles)),$this->title_separator);
    }

    function getBlock(){
	return $this->block;
    }

    function getContent(){
	return $this->content;
    }

    function setName($name){
	$this->name = $name;
	return $this;
    }

    function addTitle($title){
	$this->titles [] = $title;
	return $this;
    }

    function setBlock($block){
	$this->block = $block;
	return $this;
    }

    function setContent($content){
	$this->content = $content;
	return $this;
    }

    function getPageHeader(){
	return $this->pageHeader;
    }

    function setPageHeader($pageHeader){
	$this->pageHeader = $pageHeader;
	return $this;
    }

    function getTitle_separator(){
	return $this->title_separator;
    }

    function getTitle_direction(){
	return $this->title_direction;
    }

    function setTitle_separator($title_separator){
	$this->title_separator = $title_separator;
	return $this;
    }

    function setTitle_direction($title_direction){
	$this->title_direction = $title_direction;
	return $this;
    }
}
