<?php
namespace Core\Table;

use Donquixote\Cellbrush\Table\Table;

/**
 * Description of SimpleTable
 *
 * @author Dmitriy
 */
class SimpleTable{

    const SORT_ASC = 'asc';

    const SORT_DESC = 'desc';

    protected $beforSelectFn;

    protected $repository;

    protected $sort = 'id';

    protected $order = self::SORT_ASC;

    protected $top_panel = false;
    
    protected $bottom_panel;

    protected $limit;

    protected $page  = 1;

    protected $columns	 = [];
    
    protected $multi_sort = [];
    
    protected $navigation = true;
    
    protected $rowlist = array(10, 50, 100, 300);

    /**
     *
     * @var type 
     */
    protected $pagination;
	    
    function __construct(\Core\Repository\CrudInterface $repo){
	$this->repository = $repo;
	$this->pagination = new Pagination;
	$this->limit = input_get('rows') > 0 ? input_get('rows') : $this->rowlist[0];
	$this->page = input_get('page') > 0 ? input_get('page') : $this->page;
    }

    function getLimit(){
	return (int) $this->limit;
    }

    function setLimit($limit){
	$this->limit = $limit;
	return $this;
    }

    function getPage(){
	return (int) $this->page > 1 ? (int) $this->page : 1;
    }

    function setPage($page){
	$this->page = $page;
	return $this;
    }

    function getSort(){
	return $this->sort;
    }

    function getOrder(){
	return $this->order;
    }
    
    /**
     * Устанавливает правила сортировки
     * 
     * @param type $data
     */
    public function setSortOrder(array $data) {
        $this->multi_sort = $data;
    }
	    
    function setSort($sort){
	$this->sort = $sort;
	return $this;
    }

    function setOrder($order){
	$this->order = $order;
	return $this;
    }

    function getTop_panel(){
	return $this->top_panel;
    }

    function setTop_panel($top_panel){
	$this->top_panel = $top_panel;
	return $this;
    }

    /**
     * Пользовательская функция для выборки данных
     * @param type $fn
     */
    function beforSelectFn($fn){
	$this->beforSelectFn = $fn;
	return $this;
    }

    /**
     * Добавляем колонку
     * 
     * @param type $data
     */
    public function addColumn($Column){

	if(!$Column->getName()){
	    show_error('name column not isset');
	} elseif(!$Column->getTitle() && $Column->getName()){
	    $Column->setTitle($Column->getName());
	}

	$this->addCustomFormat($Column);

	$this->addSummColumn($Column);

	$this->columns[] = $Column;

	return $this;
    }

    /**
     * 
     * @param Column $Column
     */
    protected function addCustomFormat($Column){
	if($Column->getFn()){
	    $this->customformat[$Column->getName()] = $Column->getFn();
	}
    }

    /**
     * 
     * @param type $data
     */
    protected function addSummColumn($Column){
	if($Column->getSumm() === true){
	    $this->summary[$Column->getName()] = 0;
	}
    }

    protected function getCount(){

	return $this->repository->count();
    }

    public function Render(){

	//set_bookmark('last_table');

	$this->count_rows = $this->getCount();
	return
		'<div class="dataTables_wrapper" id="dyntable_wrapper">' . $this->renderTop() .
		$this->renderTable() .
		$this->renderBottom() .
		'</div>';
    }

    protected function renderTop(){
	
    }

    protected function renderTable(){

	$Rows = $this->getRows();

	$table = Table::create();
	$table->addClass('stdtable');
	$col_names = $build_head = [];
	$table->thead()->addRowName('head row');
	$build_str ='';
	
	foreach($this->columns as $i => $Column){
	    
	    $col_names []= $i;
	    
	    $table->thead()->th('head row', $i, $Column->getTitle() );
	    $build_str  .= sprintf('$this->prepareRow($Row,$this->columns[%s]),', $i);
	    $build_head[$i]= 'head'. ($i % 2 == 0 ? 1 : 0);
	}
	
	
	$table->addColNames($col_names);
	$table->addColClasses($build_head);
	
	$i = 0;
	$table->addRowStriping();
	if(count($Rows) > 0){
	    foreach($Rows as $Row){

		eval(sprintf('$table->addRow($i)->tdMultiple([%s]);', rtrim($build_str,',')));

		$i++;
	    }
	}
	else{
	    $table
		    ->addRowName('head row')
		    ->td('head row', '', 'В таблице нет данных');
	}

	return $table->render();
    }

    protected function renderBottom() {

        if ($this->bottom_panel === false)
            return;

        $count = $this->count_rows;

        $rows = $this->getLimit();

        $page = input_get('page') > 1 ? input_get('page') : 1;

        $min_limit = ($rows * $page) - $rows;

        $max_limit = ($min_limit + $rows) < $count ? ($min_limit + $rows) : $count;

        $min_limit = $min_limit > 0 ? $min_limit + 1 : 1;

        return '<div class="dataTables_info" id="dyntable_info">Показано ' . $min_limit . ' до ' . $max_limit . ' из ' . $count . ' записей</div>' . $this->renderPagination();
    }

    /**
     * Получение записей
     * 
     * @return type
     */
    protected function getRows(){

	$this->setNavigation();

	return $this->repository->findAll();

	$Repository = $this->repository->findAll();

	if($this->beforSelectFn){
	    $Repository = call_user_func($this->beforSelectFn, $Repository);
	}

	if(count($this->multi_sort) > 0){
	    foreach($this->multi_sort as $sort => $order){
		$Repository->{'orderBy' . $sort}($order == 'asc' ? Criteria::DESC : Criteria::ASC );
	    }
	} else{

	    $Repository->{'orderBy' . $this->sort}($this->order == 'asc' ? Criteria::DESC : Criteria::ASC );
	}

	return $Repository->paginate($this->getPage(), $this->getLimit());
    }

    /**
     * 
     * @param type $Model
     * @param type $Column
     * @return type
     */
    protected function prepareRow($row,$Column){
	if(is_callable($Column->getFn())) {
            $result = call_user_func($Column->getFn(), $row);
        }
	else{
	    $result = isset($row[$Column->getName()])? $row[$Column->getName()]: '&nbsp;';
	}
	
	return $result;
    }
    
    /**
     * Устанавиливает механизм навигации
     */
    function setNavigation(){
	
    }

   protected function renderPagination() {

        if ($this->navigation === false)
            return '<div class="dataTables_paginate" >' . nbs() . '</div>';

        $config['base_url'] = adaptive_url(array(
            'rows' => $this->getLimit()
                ), ['page']);

        $config['total_rows'] = $this->count_rows;

        $config['per_page'] = $this->getLimit();
        $config['page_query_string'] = TRUE;
        $config['num_links'] = 8;
        $config['query_string_segment'] = 'page';

        $config['use_page_numbers'] = TRUE;

        $config['full_tag_open'] = '<div class="dataTables_paginate paging_full_numbers" id="dyntable_paginate">';
        $config['full_tag_close'] = '</div>';


        $config['first_link'] = 'Первая';
        $config['first_tag_open'] = '<span class="first paginate_button" id="dyntable_first">';
        $config['first_tag_close'] = '</span>';

        $config['last_link'] = 'Последняя';
        $config['last_tag_open'] = '<span class="last paginate_button" id="dyntable_last">';
        $config['last_tag_close'] = '</span>';

        $config['cur_tag_open'] = '<span class="paginate_active">';
        $config['cur_tag_close'] = '</span>';

        $config['num_tag_open'] = '<span class="paginate_button">';
        $config['num_tag_close'] = '</span>';

        $config['next_link'] = 'Вперед';
        $config['next_tag_open'] = '<span class="next paginate_button" id="dyntable_next">';
        $config['next_tag_close'] = '</span>';

        $config['prev_link'] = 'Назад';
        $config['prev_tag_open'] = '<span class="previous paginate_button" id="dyntable_previous">';
        $config['prev_tag_close'] = '</span>';

        $this->pagination->initialize($config);

        $result = $this->pagination->create_links();

        return $result > '' ? $result : '<div class="dataTables_paginate paging_full_numbers" id="dyntable_paginate"> &nbsp;</div>';

        //return '<div class="dataTables_paginate paging_full_numbers" id="dyntable_paginate"><span class="first paginate_button paginate_button_disabled" id="dyntable_first">Первая</span><span class="previous paginate_button paginate_button_disabled" id="dyntable_previous">Назад</span><span><span class="paginate_active">1</span><span class="paginate_button">2</span><span class="paginate_button">3</span><span class="paginate_button">4</span><span class="paginate_button">5</span></span><span class="next paginate_button" id="dyntable_next">Вперед</span><span class="last paginate_button" id="dyntable_last">Последняя</span></div>';
    }
}
