<?php
namespace Core\Registry\Factory;

use Core\Form\FormBuilder;
use Core\Registry\RepoRegisry;
use Core\Repository\PropelQueryAbstract;
use Core\Template\Template;
use Core\TwigAwareInterface;
use Symfony\Component\HttpFoundation\Request;
use Twig_Environment;

/**
 * Description of newPHPClass
 *
 * @author Dmitriy
 */
class RepoRegistry implements TwigAwareInterface{
    
    protected $twig;
    
    protected $request;
    
    protected $template;
    
    protected $repoFormFactory;
    
    function __construct(Template $template,
			 Request $request,
			 FormBuilder $formBuilder){
	$this->template		 = $template;
	$this->request		 = $request;
	$this->repoFormFactory	 = $formBuilder;	
    }
    

    public function setTwig(Twig_Environment $twig){
	$this->twig = $twig;
	return $this;
    }    
    
    public function build(PropelQueryAbstract $repository,$name){
	return new RepoRegisry(
		$repository,
		$this->repoFormFactory,
		$this->template,
		$this->twig,
		$this->request,
		$name
		
		);
    }
    
}
