<?php
namespace Core;

/**
 * Description of ModuleController
 *
 * @author d.lanec
 */
abstract class ModuleController extends BaseController implements ModuleInterface{

    const DEFTPL = "default";
    
    public $tpl = false;

    protected function render($view = self::DEFTPL, $data = array()){

	if(is_array($view)){
	    $data = $view;
	    $view = self::DEFTPL;
	}
	
	if($this->tpl !== false)
	    $view = $this->tpl;
	
	$ref = new \ReflectionClass($this);
	$tpl = (new \SplFileInfo($ref->getFileName()))->getPath() . DIRECTORY_SEPARATOR . 'tpl';
	
	$this->twig->getLoader()->prependPath($tpl);
	return $this->twig->render($view . '.twig', $data);
    }

    abstract public function process();

    /**
     * set module params
     * @param array $params
     * @return $this
     * @throws \Exception
     */
    public function setParams(array $params = array()){

	foreach($params as $param => $value){
	    if(!property_exists($this, $param)){
		throw new \Exception(sprintf("property '%s' not found in module '%s'", $param, self::class));
	    }
	    $this->{$param} = $value;
	}
	return $this;
    }
}
