<?php
namespace Core;

/**
 * Description of IniConfig
 *
 * @author Dmitriy
 */
abstract class IniConfig{

    protected $data = [];

    protected $loaded = false;

    protected function getPath(){
        return APPATH . '/app/settings/' . $this->getFileName();
    }
            
    function __construct(){
	$ini_path = $this->getPath();

	if(file_exists($ini_path)){
	    $this->data = parse_ini_file($ini_path);
	    foreach($this->data as $k => $v){
		if(property_exists($this,$k)){
		    $this->{$k} = base64_decode($v);
		}
	    }
	    $this->loaded = true;
	}
    }
    
    /**
     * сохраняем файл
     * @param array $data
     */
    function save(array $data){
        
        $tmp = '';

        foreach ($data as $key => $val) {
            if(!property_exists($this,$key))
                continue;
            
            $val = base64_encode($val);
            
            $tmp .= "$key = \"" . addslashes($val) . "\"\n";
        }

        file_put_contents($this->getPath(), $tmp);
        
        return true;
    }

    abstract protected function getFileName();
}
