<?php

namespace Core\Form;

use Core\Form\RepoFormInterface;
use Core\Form\MyForm;

/**
 * Description of RepoForm
 *
 * @author Dmitriy
 */
class RepoForm extends ActiveForm
{
	function __construct(RepoFormInterface $Repository, array $fields = array())
	{
        MyForm::__construct();

        //$this->CI = & get_instance();
		$this->form_validation	= $this->CI->getConteiner()->get('form_validation');
		$this->model = $Repository;
		
		$this->addFields($fields);
		
	}
	
	public function addFieldAndButton(array $field)
	{

			if(
					is_a($field['control'],\Core\Form\Control\Button::class)
					){
					
				$this->addButton($field['name'], $field['control']);
					}
			elseif(
					is_a($field['control'], \Core\Form\Control\Hidden::class )
					){
					
				$this->addHidden($field['name'], $field['control']);
					}	
			else{
				
			
				$this->addField(
					$field['name'], 
					$field['control'],
					(isset($field['params'])?$field['params']:[]),
					(isset($field['desc'])?$field['desc']:null),
					(isset($field['label'])?$field['label']:null),
					(isset($field['rules'])?$field['rules']:null)
					);	
			
				if(isset($field['rules']))
					$this->form_validation->set_rules($field['name'], (isset($field['label'])?$field['label']:[]), $field['rules']);
			}
	}

	    /**
     * Подготовка параметров
     *
     * @param mixed $params
     * @return void
     */
    protected function prepareControl(\Core\Form\Control\FormControl $Control) {

		$alias = $Control->getName();
	
		$name = $alias;//$this->model->getAliasField($alias);
		
		if (
				(input_post($alias)!==NULL && (int)$this->row_id==0) ||
				(input_post($alias)!==NULL && 
						method_exists ($this->row_data, 'get'.$name) && input_post($alias) != $this->row_data->{'get'.$name}())
				) {

			$Control->setValue( input_post($alias)===NULL ? $Control->getValue() : input_post($alias) );
			
        } elseif (method_exists ($this->row_data, 'get'.$name) ) {
			
			$Control->setValue($this->row_data->{'get'.$name}());
			
        } 

        if ($Control->getFn()!==false) {
			
            $Control->setValue( call_user_func($Control->getFn(),$Control->getValue(),$this->row_data) );
        }
        	
		
        //return $params;
    }
	
    /**
     * Подготовка данных  из $_POST
     *
     * @return type
     */
    protected function getPostData() {
        $data = array();

        foreach ($this->fields as $field_name => $field) {

			$name = $field_name;
			
            if ($field->control == 'imgupload') {
                $data[$name] = $this->imgUpload($name);
            } else {
                $data[$name] = $this->CI->input->post($name);
            }
        }
        foreach ($this->hiddens as $name => $field) {
            $data[$name] = $this->CI->input->post($name);
        }

        return $data;
    }	
	
	/**
     * Всавляем|Обновляем только данные полей формы
     * 
     * @param type $data
     * @return type
     */
    protected function prepareInsertUpdateData($data) {
        $newdata = [];

		//определение формата массива если поля как псевдомнимы то сделаем нименования
		//как поля в базе
		foreach ($data as $key => $value){
			
			$newdata[$key]=$value;
			
		}
		return $newdata;
    }	
	
	/**
	 * 
	 * @param type $action
	 * @throws \Core\Form\Exceptions\ValidationError
	 * @throws \Core\Form\Exceptions\EntitySaveError
	 * @throws \Core\Form\Exceptions\EntitySaveSuccess
	 * @throws \Core\Form\Exceptions\EntityDeleteError
	 * @throws \Core\Form\Exceptions\EntityDeleteSuccess
	 */
	protected function ActionProcess($action){
		
		if (in_array($this->definitionAction(), array('READ', 'UPDATE','DELETE'))) {

			$this->row_data = $this->model->findById($this->getRowId());
					
        }			
		
		switch ($action) {

            //создание записи
            case 'CREATE':

				if(!$this->validate())
					throw new \Core\Form\Exceptions\ValidationError;
				
                //получение данных с поста
                $data = $this->getPostData();

                //пользовательское событие
                $data = $this->trigger('before_create', $data);

                //подготовка данных для вставки
                $insertdata = $this->prepareInsertUpdateData($data);
				
				$Entity =  $this->model->createEntity($insertdata);

				if (!$this->model->save($Entity)){
					throw new \Core\Form\Exceptions\EntitySaveError;
                } else {
                    $this->trigger('after_create', $Entity);
					throw new \Core\Form\Exceptions\EntitySaveSuccess;
                }
				
                break;

            //Обновление
            case 'UPDATE':

				if(!$this->validate())
					throw new \Core\Form\Exceptions\ValidationError;
				
                //получение данных с поста
                $data = $this->getPostData();

                //пользовательское событие
                $data = $this->trigger('before_update', $data);

                //подготовка данных для вставки

                $updatedata = $this->prepareInsertUpdateData($data);

				foreach($updatedata as $field => $value){
					if($value !== NULL)
						$this->row_data->{"set".$field}($value);
				}
				
				if (!$this->model->save($this->row_data)){
					throw new \Core\Form\Exceptions\EntitySaveError;
                } else {
                    $this->trigger('after_update', $this->row_data);
					throw new \Core\Form\Exceptions\EntitySaveSuccess;
                }

                break;

            //Удаление
            case 'DELETE':
				
                $this->trigger('before_delete', $this->row_data);

				if (! $this->model->delete($this->row_data)){
					throw new \Core\Form\Exceptions\EntityDeleteError('Не удалось удалить запись');
                } else {
					$this->trigger('after_delete', $this->row_data);
					throw new \Core\Form\Exceptions\EntityDeleteSuccess;
                }				
				

                break;

            //view
            default:

               // return $this->generateForm();

                break;
        }		
		
	}

	
}
