<?php

namespace Core\Form;

use Core\Repository\PropelQueryAbstract;
use Core\TwigAwareInterface;
use Core\TwigAwareTrait;
use Psr\Log\LoggerAwareInterface;
use Psr\Log\LoggerAwareTrait;
use Symfony\Component\HttpFoundation\Request;

/**
 * Description of FormBuilder
 *
 * @author Admin
 */
class FormBuilder implements TwigAwareInterface, LoggerAwareInterface {

    use TwigAwareTrait;

    use LoggerAwareTrait;

    protected $request;
    protected $class = "stdform stdform2";

    function __construct(Request $request) {
        $this->request = $request;
    }

    /**
     * 
     * @param type $name
     * @param type $action
     * @return \Core\Form\SettingsForm
     */
    public function buildSettingsForm(\Core\IniConfig $config,$name, $action = null) {
        return (new SettingsForm($config, $name, $action))
                        ->setTwig($this->twig)
                        ->setClass($this->class);
    }

    /**
     * 
     * @param type $name
     * @param type $action
     * @return type
     */
    public function buildSimpleValidationForm($name, $action = null) {
        return (new Simpleform($name, $action))
                        ->setTwig($this->twig)
                        ->setClass($this->class);
    }

    /**
     * 
     * @param PropelQueryAbstract $repository
     * @param type $name
     * @param type $action
     * @return type
     */
    public function buildRepoValidationForm(PropelQueryAbstract $repository, $name, $action = null) {

        $form = (new RepoForm($repository, $name, $action, $this->request))
                ->setTwig($this->twig)
                ->setClass($this->class)
        ;
        $form->setLogger($this->logger);

        return $form;
    }

}
