<?php
namespace Core\Form\Control;

/**
 * Description of Input
 *
 * @author Dmitriy
 */
class Input extends FormField
{
	protected $width;
	
	protected $type = 'text';
		
	function __construct($name, $value = null, $width = false)
	{
		$this->setName($name);
		$this->setValue($value);
		$this->setWidth($width);
	}
	
	function getType(){
	    return $this->type;
	}

	function setType($type){
	    $this->type = $type;
	    return $this;
	}
	
	function getWidth()
	{
		if($this->width>0){
			return "width:{$this->width}px";
		}
	}

	function setWidth($width)
	{
		$this->width = $width;
		return $this;
	}

	public function render()
	{
		return \form_input(array_merge([
			'name'		 => $this->getName(),
			'id'		 => $this->getId(),
			'value'		 => $this->getValue(),
			'class'		 => $this->getClass(),	
			'type'		 => $this->getType(),
//			'maxlength'	 => '100',
//			'size'		 => '50',
			'style'		 => $this->getWidth()
		],$this->getAttributes()));
	}
	
	public function getStyle()
	{
		return $this->getWidth();
	}
}
