<?php

namespace Core\Form\Control;

use Gregwar\Captcha\CaptchaBuilder;
use Symfony\Component\HttpFoundation\Session\Session;

/**
 * Description of Captcha
 *
 * @author Admin
 */
class Captcha extends FormField{
    
    protected $builder;
    
    protected $caption = "Код с картинки";
    
    protected $name_conteiner = "captcha_container";
            
    protected $width;
            
    protected $height;
    
    protected $session;
    
    protected $old_code;
            
    function __construct(Session $session) {
        $this->builder = new CaptchaBuilder;
        $this->session = $session;
        $this->old_code = $this->session->get("phrase");
        $this->session->set("phrase", $this->builder->getPhrase());   
    }
    
    function getWidth() {
        return $this->width;
    }

    function getHeight() {
        return $this->height;
    }

    function setWidth($width) {
        $this->width = $width;
        return $this;
    }

    function setHeight($height) {
        $this->height = $height;
        return $this;
    }

    
    function setCaption($caption) {
        $this->caption = $caption;
        return $this;
    }
    
    public function varifyCode($name){
        return $this->old_code == $name;
    }

    public function render() {
        $this->builder->build($this->width, $this->height);
             
        return sprintf('<div class="%s">
        <img src="%s" />
        <input type="text" name="captcha_phrase" value="%s" onfocus="if (this.value == this.defaultValue) {
                    this.value = \'\';
                }" onblur="if (this.value == \'\') {
                            this.value = this.defaultValue
                        }" required="" >
    </div>',
                $this->name_conteiner,
                $this->builder->inline(),
                $this->caption
                );
    }
    
}
