<?php

namespace Core\Form\Control;

/**
 * Description of Button
 *
 * @author Dmitriy
 */
class Button extends FormControl
{
	
	protected $onClick;
			
	function __construct($name,$value)
	{
		$this->setName($name);
		$this->setValue($value);
	}

	function getOnClick()
	{
		return $this->onClick;
	}

	function setOnClick($onClick)
	{
		$this->onClick = $onClick;
		
		return $this;
	}

	
	public function render()
	{
        return \form_button([
			'name'		 => $this->getName(),
			'type'		 => 'submit',
			'content'	 => $this->getValue(),
			'class'		 => $this->getClass(),
			'onclick'	 => $this->getOnClick()
		]);
	}
}
